package ru.yandex.calendar.admin.resources;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.calendar.logic.resource.ResourceDao;
import ru.yandex.misc.db.q.SqlOrder;

/**
 * @author ssytnik
 */
public class ResourcesManager {
    @Autowired
    private ResourceDao resourceDao;

    public ListF<Resource> getResources() {
        return resourceDao.findResourcesSorted(SqlOrder.unordered().andThen("office_id").andThen("pos"));
    }

    public Resource getResourceById(long resourceId) {
        return resourceDao.findResourceById(resourceId);
    }

    public void createResource(Resource resource) {
        resourceDao.saveResource(resource);
    }

    public void updateResource(Resource resource) {
        resourceDao.updateResource(resource);
    }

    public void deleteResource(long resourceId) {
        resourceDao.deleteResourceById(resourceId);
    }
}
