package ru.yandex.calendar.admin.specialusers;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.resource.ResourceDao;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.logic.user.UserGroupsDao;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.calendar.util.Environment;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author Daniel Brylev
 */
@Configuration
public class SpecialUsersAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;
    @Autowired
    private UserGroupsDao userGroupsDao;
    @Autowired
    private UserManager userManager;
    @Autowired
    private SettingsRoutines settingsRoutines;
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;

    @PostConstruct
    public void configure() {
        Option<String> upravlyatorUrl = Option.empty();

        if (Environment.isProductionOrPre() && passportAuthDomainsHolder.containsYandexTeamRu()) {
            upravlyatorUrl = Option.of("https://idm.yandex-team.ru/system/calendar");
        }
        if (Environment.isTesting() && passportAuthDomainsHolder.containsYandexTeamRu()) {
            upravlyatorUrl = Option.of("https://idm.test.yandex-team.ru/system/calendar");
        }
        upravlyatorUrl = Option.empty();

        if (passportAuthDomainsHolder.containsYandexTeamRu()) {
            adminApp.registerAdminPage(new SpecialUsersAdminPage(
                    userGroupsDao, userManager, settingsRoutines, resourceDao, upravlyatorUrl));
        }
    }
}
