<?xml version="1.0"?>

<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="xsl"
        version="2.0">

    <xsl:import href="./../common/common.xsl"/>

    <xsl:template match="page" mode="head-extra-x">
        <style type="text/css">
            td.view .label {
                display: inline-block;
                line-height: 1.3;
            }
            td.view .label-blue {
                background-color: #1010ff;
            }
            div.checkbox {
                font-weight: bold;
            }
            span.box-separator {
                padding-left: 20px;
            }
        </style>
    </xsl:template>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript">
            <![CDATA[
            $(document).ready(function() {
                $('.edit-link').click(function() {
                    var p = $(this).parents('.view-edit-container');

                    if (p.data('user-id')) {
                        var form = $('#edit-form-template').clone(true).appendTo(p.find('.edit'));

                        form.find(':input[name="emailOrDepartment"]').val(p.data('user-id'));

                        $(p.data('type-names').split(';')).each(function(_, value) {
                            form.find(':input[name="' + value + '"]').prop('checked', true);
                        });
                        form.show();
                        p.data('user-id', null);
                    }

                    p.find('.edit').show();
                    p.find('.view').hide();
                    return false;
                });
                $('.cancel-button').click(function() {
                    var p = $(this).parents('.view-edit-container');
                    p.find('.view').show();
                    p.find('.edit').hide();
                    return false;
                });
                $('.view-edit-container').find('.edit').hide();

                var getCookie = function(name) { return(document.cookie.match('(^|; )' + name + '=([^;]*)')||0)[2] };

                var filters = $('.user-type-filter'),
                    filterTitle = $('.user-type-filter-title'),
                    rows = $('.user-row'),
                    applyFilter = function(name) {
                        filters.parent('.disabled').removeClass('disabled');

                        var f = filters.filter('[data-name="' + name + '"]');
                        filterTitle.text(f.text());
                        f.parent().addClass('disabled');

                        rows.each(function() {
                            $(this).toggle(!name || $(this).attr('data-type-names').indexOf(';' + name + ';') >= 0)
                        });
                        document.cookie = 'special-user-type-filter=' + name;
                    };

                filters.click(function() {
                    applyFilter($(this).attr('data-name'));
                });
                applyFilter(getCookie('special-user-type-filter') || '');
            });
        ]]>
        </script>
    </xsl:template>

    <xsl:variable name="items">
        <xsl:copy-of select="/page/user-info-list/role-info"/>
    </xsl:variable>

    <xsl:variable name="upravlyator-url" select="/page/user-info-list/upravlyator-url"/>

    <xsl:template match="page" mode="content-centered">
        <xsl:call-template name="add-user-block"/>
        <xsl:apply-templates select="user-info-list"/>
    </xsl:template>

    <xsl:template name="add-user-block">
        <xsl:if test="not($upravlyator-url)">
            <xsl:call-template name="edit-user-form"/>

            <div class="view-edit-container">
                <div class="view control-group"><a href="#" class="edit-link">Add new one</a></div>
                <div class="edit well" style="display:none"><xsl:call-template name="add-user-form"/></div>
            </div>
        </xsl:if>
        <xsl:if test="$upravlyator-url">
            <a href="{$upravlyator-url}" target="_blank">Add new one</a>
        </xsl:if>
    </xsl:template>

    <xsl:template match="user-info-list">
        <table class="table table-striped">
            <colgroup>
                <col class="span4"/>
                <col class="span2"/>
            </colgroup>
            <tbody>
                <tr>
                    <td width="350px"/>
                    <td>
                        <div class="btn-group">
                            <a class="btn btn-mini dropdown-toggle" data-toggle="dropdown" href="#">
                                <i class="icon-filter"/>
                                <span class="user-type-filter-title"/>&#160;
                                <span class="caret"/>
                            </a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a href="#" class="user-type-filter" data-name="">Any</a>
                                </li>
                                <xsl:for-each select="$items/role-info">
                                    <li>
                                        <a href="#" class="user-type-filter" data-name="{@name}">
                                            <xsl:value-of select="@display-name"/>
                                        </a>
                                    </li>
                                </xsl:for-each>
                            </ul>
                        </div>
                    </td>
                    <td/>
                </tr>
                <xsl:for-each select="user-info|department-info">
                    <xsl:variable name="items-checked">
                        <xsl:variable name="groups" select="groups/group|roles/role"/>

                        <xsl:for-each select="$items/role-info">
                            <xsl:variable name="name" select="@name"/>
                            <xsl:if test="$groups[. = $name]">
                                <xsl:copy-of select="."/>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:variable>
                    <tr class="view-edit-container user-row" data-type-names=";{string-join($items-checked/role-info/@name, ';')};" data-user-id="{@email|@department}">
                        <td>
                            <xsl:choose>
                                <xsl:when test="@department[starts-with(., 'svc_')]">
                                    <a href="https://abc.yandex-team.ru/services/{substring-after(@department, 'svc_')}/"><xsl:value-of select="@department"/></a>
                                </xsl:when>
                                <xsl:when test="@department[. = '*']">
                                    <xsl:value-of select="'Any user'"/>
                                </xsl:when>
                                <xsl:when test="@department">
                                    <a href="https://staff.yandex-team.ru/departments/{@department}/"><xsl:value-of select="@department"/></a>
                                </xsl:when>
                                <xsl:when test="@yt-login">
                                    <img src="https://center.yandex-team.ru/user/avatar/{@yt-login}/24/square"/>
                                    <xsl:text>&#32;</xsl:text>
                                    <a href="https://staff.yandex-team.ru/{@yt-login}/"><xsl:value-of select="@email"/></a>
                                </xsl:when>
                                <xsl:otherwise>
                                    <a href="/z/user?q={@email}"><xsl:value-of select="@email"/></a>
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                        <td class="view">
                            <xsl:for-each select="$items-checked/role-info">
                                <span class="label {@label-class}">
                                    <xsl:value-of select="@display-name"/>
                                </span>
                                <xsl:if test="last() > position()">&#160;</xsl:if>
                            </xsl:for-each>
                        </td>
                        <xsl:if test="not($upravlyator-url)">
                            <td class="view"><a href="#" class="edit-link">Edit</a></td>
                            <td class="edit" colspan="2" style="display:none"/>
                        </xsl:if>
                        <xsl:if test="$upravlyator-url">
                            <td/>
                        </xsl:if>
                    </tr>
                </xsl:for-each>
            </tbody>

        </table>
    </xsl:template>

    <xsl:template name="add-user-form">
        <form method="GET" action="/z/special-users/create">
            <fieldset>
                <div class="span">
                    <div class="control-group">
                        <input type="text" name="emailOrDepartment" class="input-large" placeholder="User email or department"/>
                    </div>
                    <div class="control-group">
                        <xsl:call-template name="checkboxes"/>
                    </div>
                    <div>
                        <button class="btn btn-primary input-small">Save</button>
                        <button class="cancel-button btn">Cancel</button>
                    </div>
                </div>
            </fieldset>
        </form>
    </xsl:template>

    <xsl:template name="edit-user-form">
        <form method="GET" action="/z/special-users/save" id="edit-form-template" style="display: none;">
            <fieldset>
                <input type="hidden" name="emailOrDepartment" value=""/>

                <div class="control-group">
                    <xsl:call-template name="checkboxes"/>
                </div>
                <div class="control-group">
                    <button class="btn btn-primary input-small">Update</button>
                    <button class="cancel-button btn">Cancel</button>
                </div>
            </fieldset>
        </form>
    </xsl:template>

    <xsl:template name="checkboxes">
        <xsl:for-each select="$items/role-info">
            <xsl:variable name="prev" select="preceding-sibling::*[1]"/>
            <xsl:variable name="next" select="following-sibling::*[1]"/>

            <xsl:if test="not(@group) or not($prev/@group) or $prev/@group != @group">
                <div class="checkbox">
                    <input type="checkbox" name="{@name}" value="true"/>

                    <xsl:if test="@group and $next/@group = @group">
                        <span class="box-separator"/>

                        <input type="checkbox" name="{$next/@name}" value="true"/>
                    </xsl:if>

                    <xsl:if test="string(number(@group)) != 'NaN'">
                        <xsl:value-of select="concat('(', @group, ') ')"/>
                    </xsl:if>

                    <xsl:value-of select="@display-name"/>

                    <xsl:if test="@group and $next/@group = @group">
                        <xsl:value-of select="concat(' / ', substring-after($next/@name, '-'))"/>
                    </xsl:if>
                </div>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

</xsl:stylesheet>
