package ru.yandex.calendar.admin.todos;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.logic.stat.TodoStatisticsManager;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.json.jackson.JacksonContextConfiguration;
import ru.yandex.commune.json.jackson.ObjectMapperX;

/**
 * @author Daniel Brylev
 */
@Configuration
@Import(
        JacksonContextConfiguration.class
)
public class TodoStatsAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;
    @Autowired
    private TodoStatisticsManager todoStatisticsManager;
    @Autowired
    private ObjectMapperX objectMapper;

    @PostConstruct
    public void configure() {
        adminApp.registerAdminPage(new TodoStatsAdminPage(todoStatisticsManager, objectMapper));
    }
}
