<?xml version="1.0"?>

<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:math="http://exslt.org/math"
        exclude-result-prefixes="xsl math"
        version="1.0">

    <xsl:import href="classpath:ru/yandex/calendar/admin/common/common.xsl"/>

    <xsl:template match="page" mode="head-extra-x">
        <script type="text/javascript" src="/z/r/todo-stats/amcharts/amcharts.js"/>
        <script type="text/javascript" src="/z/r/todo-stats/amcharts/raphael.js"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content/tabs"/>
        <xsl:apply-templates select="content/chart"/>
    </xsl:template>

    <xsl:template match="tabs">
        <ul class="nav nav-tabs">
            <xsl:for-each select="tab">
                <li>
                    <xsl:if test="@active"><xsl:attribute name="class">active</xsl:attribute></xsl:if>
                    <a href="/z/todo-stats/{@id}"><xsl:value-of select="@title"/></a>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>

    <xsl:template match="chart">
        <xsl:apply-templates select="error"/>
        <xsl:if test="not(error)">
            <xsl:apply-templates select="." mode="draw"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="chart" mode="draw">
        <xsl:variable name="id" select="concat('chart-', math:random())"/>
        <div id="{$id}" style="width: 100%; height: 400px;"/>
        <script type="text/javascript">
            AmCharts.ready(function () {
                var chart = new AmCharts.AmSerialChart();
                chart.addTitle("<xsl:value-of select="@title"/>", 14);
                chart.dataProvider = <xsl:value-of select="data"/>;
                chart.categoryField = "<xsl:value-of select="@category-field"/>";

                <xsl:for-each select="graph">
                    var graph = new AmCharts.AmGraph();
                    graph.type = "line";
                    graph.title = "<xsl:value-of select="@title"/>";
                    graph.valueField = "<xsl:value-of select="@value-field"/>";
                    graph.lineThickness = 2;
                    chart.addGraph(graph);
                </xsl:for-each>

                chart.pathToImages = "/z/r/todo-stats/amcharts/images/";
                chart.balloon.bulletSize = 4;
                chart.zoomOutButton = {
                    backgroundColor: '#000000',
                    backgroundAlpha: 0.15
                };
                chart.addListener("dataUpdated", function() {
                    chart.zoomToIndexes(chart.dataProvider.length - 30, chart.dataProvider.length - 1);
                });
                chart.numberFormatter = {
                    precision: -1,
                    decimalSeparator:'.',
                    thousandsSeparator:' '
                };

                var categoryAxis = chart.categoryAxis;
                categoryAxis.parseDates = true;
                categoryAxis.minPeriod = "DD";
                categoryAxis.gridAlpha = 0.15;
                categoryAxis.dashLength = 1;
                categoryAxis.axisColor = "#DADADA";
                categoryAxis.position = "bottom";

                var valueAxis = new AmCharts.ValueAxis();
                valueAxis.axisAlpha = 0;
                valueAxis.dashLength = 1;
                chart.addValueAxis(valueAxis);

                var cursor = new AmCharts.ChartCursor();
                cursor.cursorPosition = "mouse";
                cursor.pan = true;
                chart.addChartCursor(cursor);

                var scrollbar = new AmCharts.ChartScrollbar();
                scrollbar.scrollbarHeight = 35;
                scrollbar.autoGridCount = true;
                scrollbar.graph = chart.graphs[0];
                chart.addChartScrollbar(scrollbar);

                var legend = new AmCharts.AmLegend();
                legend.valueText = null;
                legend.equalWidths = false;
                legend.addListener("hideItem", function(e) {
                    for (var i in chart.graphs) {
                        if (chart.graphs[i] != e.dataItem &amp;&amp; !chart.graphs[i].hidden) {
                            return scrollbar.graph = chart.graphs[i];
                        }
                    }
                });
                legend.addListener("showItem", function(e) {
                    for (var i in chart.graphs) {
                        if (chart.graphs[i] == e.dataItem || !chart.graphs[i].hidden) {
                            return scrollbar.graph = chart.graphs[i];
                        }
                    }
                });
                chart.addLegend(legend);

                chart.write("<xsl:value-of select="$id"/>");
            });
        </script>
    </xsl:template>
</xsl:stylesheet>
