package ru.yandex.calendar.admin.universal;

import javax.xml.bind.JAXBElement;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.util.serialize.ToMultilineSerializer;
import ru.yandex.commune.util.serialize.reflect.ReflectionSerializerPluginBase;

/**
 * @author Stepan Koltsov
 */
public class CalendarReflectionToMultilineSerializerPlugin extends ReflectionSerializerPluginBase {

    public CalendarReflectionToMultilineSerializerPlugin(ToMultilineSerializer toMultilineSerializer) {
        super(toMultilineSerializer);
    }

    @Override
    public Option<String> serialize(Object o) {
        if (o instanceof Enum) {
            return Option.of(((Enum) o).name());
        }
        if (o instanceof JAXBElement) {
            return super.serialize(((JAXBElement) o).getValue());
        }
        return super.serialize(o);
    }

    @Override
    protected boolean accept(Object o) {
        if (o.getClass().getName().startsWith("com.microsoft.") && o.getClass().getName().endsWith("Type")) {
            return true;
        }
        return o.getClass().equals(JAXBElement.class);
    }

} //~
