package ru.yandex.calendar.admin.universal;

import java.util.Collection;

import javax.xml.bind.JAXBElement;

import org.apache.commons.lang3.builder.RecursiveToStringStyle;

import ru.yandex.bolts.collection.Cf;

/**
 * @author dbrylev
 */
public class CalendarReflectionToStringStyle extends RecursiveToStringStyle {

    {
        setUseShortClassName(true);
        setUseIdentityHashCode(false);
    }

    @Override
    public void appendDetail(StringBuffer buffer, String fieldName, Object value) {
        if (value instanceof Enum) {
            super.appendDetail(buffer, fieldName, ((Enum) value).name());

        } else if (value instanceof JAXBElement) {
            super.appendDetail(buffer, fieldName, ((JAXBElement) value).getValue());

        } else {
            super.appendDetail(buffer, fieldName, value);
        }
    }

    @Override
    public void append(StringBuffer buffer, String fieldName, Object value, Boolean fullDetail) {
        if (value instanceof Collection) {
            super.append(buffer, fieldName, Cf.x((Collection<?>) value).toArray(), fullDetail);

        } else if (value != null) {
            super.append(buffer, fieldName, value, fullDetail);
        }
    }
}
