package ru.yandex.calendar.admin.universal;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.commune.util.serialize.ToMultilineSerializer;
import ru.yandex.commune.util.serialize.ToMultilineSerializerPlugin;
import ru.yandex.commune.util.universal.UniversalObjectParserContextConfiguration;

/**
 * @author Stepan Koltsov
 */
@Configuration
@Import({ UniversalObjectParserContextConfiguration.class })
public class CalendarUniversalContextConfiguration {

    @Bean
    public UserUniversalObjectParserPlugin userUniversalObjectParserPlugin() {
        return new UserUniversalObjectParserPlugin();
    }

    @Bean
    public ToMultilineSerializerPlugin calendarReflectionToMultilineSerializerPlugin(ToMultilineSerializer serializer) {
        ToMultilineSerializerPlugin plugin = new CalendarReflectionToMultilineSerializerPlugin(serializer);
        serializer.addPlugin(plugin);
        return plugin;
    }

} //~
