package ru.yandex.calendar.admin.universal;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.commune.util.universal.UniversalObjectParser;
import ru.yandex.commune.util.universal.UniversalObjectParserPlugin;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.TypeX;

/**
 * @author Stepan Koltsov
 */
public class UserUniversalObjectParserPlugin extends UniversalObjectParserPlugin {

    @Autowired
    private UniversalObjectParser universalObjectParser;

    @Autowired
    private UserManager userManager;

    @Override
    public Optional<Function<String, Object>> parser(TypeX type) {
        if (type.erasure().sameAs(PassportUid.class)) {
            return Optional.of(string -> {
                try {
                    return new PassportUid(Long.parseLong(string));
                } catch (Exception e) {
                    // ok
                }
                Email email;
                if (string.endsWith("@")) {
                    // XXX: yandex.ru for public
                    email = new Email(string + "yandex-team.ru");
                } else {
                    email = new Email(string);
                }
                return userManager.getUidByEmail(email).get();
            });
        } else if (type.erasure().sameAs(UidOrResourceId.class)) {
            // XXX: parse resource too
            return Optional.of(string -> UidOrResourceId.user(
                    (PassportUid) universalObjectParser.parse(string, ClassX.wrap(PassportUid.class))));
        }
        return Optional.empty();
    }

} //~
