package ru.yandex.calendar.admin.user;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.admin.BeanXmlizerForAdmin;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author Stepan Koltsov
 */
@Configuration
public class UserAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;
    @Autowired
    private BeanXmlizerForAdmin beanXmlizerForAdmin;

    @Bean
    public UserAdminManager userAdminManager() {
        return new UserAdminManager();
    }

    @PostConstruct
    public void configure() {
        adminApp.registerAdminPage(new UserAdminPage(userAdminManager(), beanXmlizerForAdmin));
    }
}
