package ru.yandex.calendar.admin.user;

import java.util.NoSuchElementException;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventFields;
import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.beans.generated.EventUserFields;
import ru.yandex.calendar.logic.beans.generated.MainEvent;
import ru.yandex.calendar.logic.beans.generated.MainEventFields;
import ru.yandex.calendar.logic.beans.generated.SettingsFields;
import ru.yandex.calendar.logic.event.EventLayerWithRelations;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.dao.EventDao;
import ru.yandex.calendar.logic.event.dao.EventLayerDao;
import ru.yandex.calendar.logic.event.dao.EventUserDao;
import ru.yandex.calendar.logic.event.dao.MainEventDao;
import ru.yandex.calendar.logic.user.SettingsInfo;
import ru.yandex.calendar.logic.user.UserDao;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.inside.passport.PassportUid;

public class UserAdminManager {
    @Autowired
    private UserDao userDao;
    @Autowired
    private EventRoutines eventRoutines;
    @Autowired
    private EventDao eventDao;
    @Autowired
    private MainEventDao mainEventDao;
    @Autowired
    private EventUserDao eventUserDao;
    @Autowired
    private EventLayerDao eventLayerDao;

    public SettingsInfo getUserByAny(final String q) {
        Option<SettingsInfo> settings = Cf.Long.parseSafe(q)
                .filterMap(uid -> userDao.findSettingsByUid(PassportUid.cons(uid)));

        if (settings.isPresent()) {
            return settings.get();
        }
        MapField<?>[] fields = new MapField<?>[] {
            SettingsFields.EMAIL, SettingsFields.YANDEX_EMAIL, SettingsFields.USER_LOGIN
        };
        for (final MapField<?> field : fields) {
            settings = userDao.findSettingsByField(field, q);
            if (settings.isPresent()) {
                return settings.get();
            }
        }
        throw new NoSuchElementException("Settings cannot be found by q = " + q);
    }

    public ListF<UserEventInfo> findLastUserEvents(PassportUid uid) {
        ListF<Long> eventIds = eventRoutines.findRelatedEvents(uid);

        ListF<Event> events = eventDao.findEventsByIds(eventIds).takeSortedByDesc(Event.getStartTsF(), 200);

        final MapF<Long, MainEvent> mainEventsById = mainEventDao.findMainEventsByIds(events.map(EventFields.MAIN_EVENT_ID.getF())).toMapMappingToKey(MainEventFields.ID.getF());

        final MapF<Long, EventUser> eventUsersByEventId =
            eventUserDao.findEventUsersByEventIdsAndUid(eventIds, uid)
                .toMapMappingToKey(EventUserFields.EVENT_ID.getF());
        final MapF<Long, EventLayer> eventLayersByEventId =
            eventLayerDao.findEventLayersWithRelationsByEventIdsAndLayerCreatorUid(eventIds, uid)
                .toMap(EventLayerWithRelations::getEventId, EventLayerWithRelations::getEventLayer);

        return events.map(event -> {
            Option<EventUser> eventUserO = eventUsersByEventId.getO(event.getId());
            Option<EventLayer> eventLayerO = eventLayersByEventId.getO(event.getId());
            return new UserEventInfo(mainEventsById.getOrThrow(event.getMainEventId()), event, eventUserO, eventLayerO);
        });
    }
}
