<?xml version="1.0"?>

<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="xsl"
        version="1.0">

    <xsl:import href="./../common/common.xsl"/>

    <xsl:variable name="q" select="/page/req/query/param[@name='q']/@value"/>

    <xsl:template match="page" mode="content-centered">
        <form method="GET" class="well">
            <input type="text" name="q" value="{$q}" class="input-xlarge" placeholder="User name, uid, email, login..."/>
            <button class="btn">I'm Feeling Lucky</button>
        </form>
        <xsl:apply-templates select="user"/>
    </xsl:template>
    
    <xsl:template match="user">
        <ul class="nav nav-tabs">
            <li>
                <xsl:if test="@current-tab = 'settings'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>
                <a href="/z/user/settings?q={$q}">Settings</a>
            </li>
            <li>
                <xsl:if test="@current-tab = 'events'"><xsl:attribute name="class">active</xsl:attribute></xsl:if>
                <a href="/z/user/events?q={$q}">Last events</a>
            </li>
        </ul>
        <xsl:apply-templates select="settings-yt" mode="as-table"/>
        <xsl:apply-templates select="settings" mode="as-table"/>
        <xsl:apply-templates select="events"/>
    </xsl:template>
    
    <xsl:template match="events">
        <table class="table table-condensed table-striped">
            <tr>
                <th>id</th>
                <th>main id</th>
                <th>name</th>
                <th>start ts</th>
                <th>eu</th>
                <th>el</th>
            </tr>
            <xsl:apply-templates select="event-with-relations"/>
        </table>
    </xsl:template>
    
    <xsl:template match="*" mode="event-link">
        <a href="/z/event?q={.}"><xsl:value-of select="."/></a>
    </xsl:template>
    
    <xsl:template match="event-with-relations">
        <tr>
            <td>
                <xsl:apply-templates select="event/id" mode="event-link"/>
            </td>
            <td style="white-space: nowrap; max-width: 20em; overflow: hidden">
                <xsl:apply-templates select="main-event/external-id" mode="event-link"/>
            </td>
            <td style="white-space: nowrap; max-width: 20em; overflow: hidden">
                <xsl:value-of select="event/name"/>
            </td>
            <td style="white-space: nowrap; max-width: 20em; overflow: hidden">
                <xsl:value-of select="event/start-ts"/>
            </td>
            <td>
                <xsl:choose>
                    <xsl:when test="event-user">
                        <xsl:value-of select="event-user/id"/>
                    </xsl:when>
                    <xsl:otherwise>
                        no event_user
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td>
                <xsl:choose>
                    <xsl:when test="event-layer">
                        <xsl:value-of select="event-layer/id"/>
                    </xsl:when>
                    <xsl:otherwise>
                        no event_layer
                    </xsl:otherwise>
                </xsl:choose>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet>
