package ru.yandex.calendar.admin.user;

import org.dom4j.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.admin.BeanXmlizerForAdmin;
import ru.yandex.calendar.logic.user.SettingsInfo;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @author Stepan Koltsov
 */
@ActionContainer
public class UserAdminPage {

    private final UserAdminManager userAdminManager;
    private final BeanXmlizerForAdmin beanXmlizerForAdmin;

    public UserAdminPage(UserAdminManager userAdminManager, BeanXmlizerForAdmin beanXmlizerForAdmin) {
        this.userAdminManager = userAdminManager;
        this.beanXmlizerForAdmin = beanXmlizerForAdmin;
    }

    @ZAction(defaultAction = true)
    @Path("/user")
    public Element index(
            @RequestParam("q")
            Option<String> queryO)
    {
        return index("settings", queryO);
    }

    @ZAction
    @Path("/user/{tab}")
    public Element index(
            @PathParam("tab")
            String tab,
            @RequestParam("q")
            Option<String> queryO)
    {
        String q = queryO.getOrElse("");
        if (StringUtils.isEmpty(q)) {
            return Dom4jUtils.createElement("default-user");
        }

        Element userElement = Dom4jUtils.createElement("user");
        userElement.addAttribute("current-tab", tab);

        if (tab.equalsIgnoreCase("settings")) {
            SettingsInfo settings = userAdminManager.getUserByAny(q);
            userElement.add(beanXmlizerForAdmin.xmlize(settings.getCommon()));
            if (settings.getYt().isPresent()) {
                userElement.add(beanXmlizerForAdmin.xmlize(settings.getYt().get()));
            }

        } else if (tab.equalsIgnoreCase("events")) {
            PassportUid uid = userAdminManager.getUserByAny(q).getUid();
            Element eventsElement = userElement.addElement("events");
            for (UserEventInfo userEventInfo : userAdminManager.findLastUserEvents(uid)) {
                Element element = eventsElement.addElement("event-with-relations");

                element.add(beanXmlizerForAdmin.xmlize(userEventInfo.getMainEvent()));
                element.add(beanXmlizerForAdmin.xmlize(userEventInfo.getEvent()));
                if (userEventInfo.getEventUser().isPresent()) {
                    element.add(beanXmlizerForAdmin.xmlize(userEventInfo.getEventUser().get()));
                }
                if (userEventInfo.getEventLayer().isPresent()) {
                    element.add(beanXmlizerForAdmin.xmlize(userEventInfo.getEventLayer().get()));
                }
            }
        } else {
            throw new ZRedirectException("/user");
        }

        return userElement;
    }
}
