package ru.yandex.calendar.admin.user;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventLayer;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.beans.generated.MainEvent;

/**
 * @author Stepan Koltsov
 */
public class UserEventInfo {
    private final MainEvent mainEvent;
    private final Event event;
    private final Option<EventUser> eventUser;
    private final Option<EventLayer> eventLayer;

    public UserEventInfo(MainEvent mainEvent, Event event, Option<EventUser> eventUser, Option<EventLayer> eventLayer) {
        this.mainEvent = mainEvent;
        this.event = event;
        this.eventUser = eventUser;
        this.eventLayer = eventLayer;
    }

    public MainEvent getMainEvent() {
        return mainEvent;
    }

    public Event getEvent() {
        return event;
    }

    public Option<EventUser> getEventUser() {
        return eventUser;
    }

    public Option<EventLayer> getEventLayer() {
        return eventLayer;
    }

} //~
