package ru.yandex.calendar.boot;

import ru.yandex.misc.enums.EnumResolver;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.version.AppName;

/**
 * @author Stepan Koltsov
 */
public enum CalendarAppName implements AppName {
    TEST,
    WEB,
    HELPER,
    CALDAV,
    WORKER,
    ;
    //do not add names that already exist as prefixes in property files! (for example: CALDAV)

    public String xmlName() {
        return name().toLowerCase().replace("_", "-");
    }

    @Override
    public String serviceName() {
        return "calendar";
    }

    @Override
    public String appName() {
        if (EnvironmentType.getActive() == EnvironmentType.PRESTABLE) {
            return xmlName() + "-prestable";
        }
        return xmlName();
    }

    public static final EnumResolver<CalendarAppName> R = EnumResolver.er(CalendarAppName.class);

} //~
