package ru.yandex.calendar.boot;

import javax.sql.DataSource;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.util.db.CalendarQueryInterceptors;
import ru.yandex.calendar.util.db.ReadFromSlaveQueryInterceptor;
import ru.yandex.commune.bazinga.pg.context.PgBazingaClientContextConfiguration;
import ru.yandex.commune.bazinga.pg.storage.PgBazingaStorageConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        CalendarJdbcContextConfiguration.class,
        PgBazingaClientContextConfiguration.class
})
public class CalendarBazingaClientContextConfiguration {

    @Bean
    public ReadFromSlaveQueryInterceptor bazingaReadSlaveInterceptor() {
        return new ReadFromSlaveQueryInterceptor("bazinga");
    }

    @Bean
    public PgBazingaStorageConfiguration pgBazingaStorageConfiguration(DataSource calendarDataSource) {
        return new PgBazingaStorageConfiguration(
                calendarDataSource,
                Option.of(CalendarQueryInterceptors.create(calendarDataSource, bazingaReadSlaveInterceptor())),
                () -> true
        );
    }
}
