package ru.yandex.calendar.boot;

import java.beans.PropertyEditor;

import org.joda.time.Duration;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.misc.property.eval.PropertyPlaceholderConfigurer2;
import ru.yandex.misc.spring.ServicesStarter;
import ru.yandex.misc.time.DurationPropertyEditor;

@Configuration
public class CalendarInitContextConfiguration {
    @Bean
    public PropertyPlaceholderConfigurer2 propertyPlaceholderConfigurer() {
        final PropertyPlaceholderConfigurer2 configurer2 = new PropertyPlaceholderConfigurer2();
        configurer2.setProperties(PropertiesHolder.properties());
        return configurer2;
    }

    @Bean
    public static CustomEditorConfigurer customEditorConfigurer() {
        final CustomEditorConfigurer configurer = new CustomEditorConfigurer();
        configurer.setCustomEditors(Cf.<Class<?>, Class<? extends PropertyEditor>>map()
                .plus1(Duration.class, DurationPropertyEditor.class)
        );
        return configurer;
    }


    @Bean
    public ServicesStarter servicesStarter() {
        return new ServicesStarter();
    }
}
