package ru.yandex.calendar.boot;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.admin.CalendarModeratorContextStarter;
import ru.yandex.calendar.frontend.api.ApiContextConfiguration;
import ru.yandex.calendar.frontend.display.DisplayContextConfiguration;
import ru.yandex.calendar.frontend.ews.hook.EwsFirewallContextConfiguration;
import ru.yandex.calendar.frontend.ews.hook.EwsNtfContextConfiguration;
import ru.yandex.calendar.frontend.ews.proxy.EwsProxyChecker;
import ru.yandex.calendar.frontend.kiosk.KioskContextConfiguration;
import ru.yandex.calendar.frontend.mailhook.MailhookContextConfiguration;
import ru.yandex.calendar.frontend.web.CalendarServantA3Configuration;
import ru.yandex.calendar.frontend.web.cmd.generic.CommandExecutor;
import ru.yandex.calendar.frontend.webNew.WebNewContextConfiguration;
import ru.yandex.calendar.logic.event.reminders.RemindersContextConfiguration;
import ru.yandex.calendar.logic.mailer.MailerContextLogbrokerConfiguration;
import ru.yandex.calendar.monitoring.DynamicMonitoringContextConfiguration;
import ru.yandex.calendar.monitoring.EwsSensors;
import ru.yandex.calendar.monitoring.WebApiMonitoringConfiguration;
import ru.yandex.calendar.unistat.ApiUnistatContextConfiguration;
import ru.yandex.calendar.util.spring.ChildApplicationContextLoader;

/**
 * @see CalendarAppName#WEB
 */
@Import({
    EwsNtfContextConfiguration.class,
    EwsFirewallContextConfiguration.class,
    MailhookContextConfiguration.class,
    ApiContextConfiguration.class,
    KioskContextConfiguration.class,
    DisplayContextConfiguration.class,
    WebApiMonitoringConfiguration.class,
    WebNewContextConfiguration.class,
    RemindersContextConfiguration.class,
    MailerContextLogbrokerConfiguration.class,
    DynamicMonitoringContextConfiguration.class,
    ApiUnistatContextConfiguration.class,
})
public class CalendarWebAppContextConfiguration {

    @Bean
    public EwsSensors ewsSensors(MeterRegistry registry, EwsProxyChecker ewsProxyChecker) {
        return new EwsSensors(registry, ewsProxyChecker);
    }

    @Bean
    public CommandExecutor commandExecutor() {
        return new CommandExecutor();
    }

    @Bean
    public ChildApplicationContextLoader calendarServantA3ContextLoader() {
        return new ChildApplicationContextLoader(CalendarServantA3Configuration.class);
    }

    @Bean
    public CalendarModeratorContextStarter moderatorContextStarter() {
        return new CalendarModeratorContextStarter();
    }
}
