package ru.yandex.calendar.boot;

import lombok.Value;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;

@Value
public class DatabaseCredentials {
    Either<String, String> hostOrGroupHosts;
    int port;
    String dbName;
    String user;
    String password;

    public Option<String> getHost() {
        return hostOrGroupHosts.leftO();
    }

    public Option<String> getGroupHosts() {
        return hostOrGroupHosts.rightO();
    }
}
