package ru.yandex.calendar.boot;


import ru.yandex.calendar.frontend.api.ApiContextConfiguration;
import ru.yandex.calendar.frontend.caldav.CaldavContextConfiguration;
import ru.yandex.calendar.frontend.worker.WorkerContextConfiguration;
import ru.yandex.calendar.tvm.TvmClientConfiguration;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Stepan Koltsov
 */
public class Main extends CalendarMainSupport {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    private final CalendarAppName appName;

    public Main(CalendarAppName appName) {
        this.appName = appName;
    }

    public static void main(String[] args) throws Exception {
        CalendarAppName appName = resolveAppName(args[0]);
        Thread.setDefaultUncaughtExceptionHandler(
                (t, e) -> LOG.error("Uncaught Exception in thread {}", t, e)
        );
        new Main(appName).runMain(args);
    }

    protected static CalendarAppName resolveAppName(String appName) {
        switch (appName) {
            case "caldav":
                return CalendarAppName.CALDAV;
            case "web":
                return CalendarAppName.WEB;
            case "worker":
                return CalendarAppName.WORKER;
            default:
                throw new IllegalArgumentException("wrong application name");
        }
    }

    @Override
    protected Class[] applicationSpecificContextPath() {
        if (appName == CalendarAppName.CALDAV) {
            return new Class[] { CaldavContextConfiguration.class, TvmClientConfiguration.class };
        } else if (appName == CalendarAppName.WEB) {
            return new Class[] {
                    ApiContextConfiguration.class,
                    CalendarWebAppContextConfiguration.class,
                    TvmClientConfiguration.class};
        } else if (appName == CalendarAppName.WORKER) {
            return new Class[] { WorkerContextConfiguration.class, TvmClientConfiguration.class };
        } else {
            throw new IllegalStateException("unknown app name: " + appName);
        }
    }

    @Override
    protected CalendarAppName appName() {
        return appName;
    }
} //~
