package ru.yandex.calendar.boot;

import java.util.List;

import lombok.val;
import one.util.streamex.StreamEx;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.logic.domain.PassportAuthDomains;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.micro.MicroCoreContext;
import ru.yandex.misc.env.EnvironmentType;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;

@Configuration
public class MicroCoreContextConfiguration {
    private static List<String> resolveEnvironments(PassportAuthDomains domains) {
        switch (domains) {
            case BOTH:
                return List.of("public", "yt");
            case PUBLIC:
                return singletonList("public");
            case YT:
                return singletonList("yt");
            default:
                return emptyList();
        }
    }

    @Bean(destroyMethod = "close")
    public MicroCoreContext microCore(PassportAuthDomainsHolder domainsHolder) {
        val active = EnvironmentType.getActive().getValue();
        val domains = resolveEnvironments(domainsHolder.getDomains());
        val environments = StreamEx.of(domains)
            .map(domain -> domain + '_' + active)
            .append(active)
            .append(domains)
            .toArray(String[]::new);

        return new MicroCoreContext(environments);
    }
}
