package ru.yandex.calendar.frontend;

import java.util.Optional;
import java.util.function.Function;

import javax.servlet.http.HttpServletRequest;

import lombok.experimental.UtilityClass;

import ru.yandex.commune.a3.action.invoke.ActionInvocation;

@UtilityClass
public class HeaderUtils {
    public static Function<String, Optional<String>> getHeaderReader(ActionInvocation invocation) {
        return header -> invocation.getWebRequest().getHeader(header).toOptional();
    }

    public static Function<String, Optional<String>> getHeaderReader(HttpServletRequest req) {
        return header -> Optional.ofNullable(req.getHeader(header));
    }
}
