package ru.yandex.calendar.frontend.a3.bind;

import java.io.OutputStream;

import ru.yandex.calendar.util.json.BendableJsonWriter;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.AbstractResultSerializer;
import ru.yandex.commune.a3.action.result.json.JsonWriterUtils;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.commune.json.write.JsonWriter;
import ru.yandex.commune.json.write.JsonWriterFactory;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author dbrylev
 */
public class JsonActionResultSerializer extends AbstractResultSerializer {

    private final BenderMapper benderMapper;

    public JsonActionResultSerializer(BenderMapper benderMapper) {
        this.benderMapper = benderMapper;
    }

    @Override
    protected boolean supports(Object result) {
        return result.getClass().isAnnotationPresent(JsonActionResult.class);
    }

    @Override
    protected void serializeSafely(Object result, ActionInvocationContext context, OutputStream outputStream) {
        JsonWriter jw = JsonWriterFactory.defaultFactory().createJsonWriter(outputStream);

        jw.writeObjectStart();
        jw.writeObjectFieldStart("invocation-info");
        JsonWriterUtils.writeAdditionalAttrs(jw, context.getAdditionalAttrs());
        jw.writeObjectEnd();

        String resultFieldName = result.getClass().getAnnotation(JsonActionResult.class).resultFieldName();

        jw.writeFieldName(resultFieldName);
        benderMapper.serializeJson(result, new BendableJsonWriter(jw));

        jw.writeObjectEnd();
        jw.flush();
    }

    @Override
    protected MediaType getContentType() {
        return MediaType.APPLICATION_JSON;
    }
}
