package ru.yandex.calendar.frontend.a3.converters;

import javax.annotation.Nullable;

import org.joda.time.LocalDateTime;

import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.convert.ConverterToType;
import ru.yandex.misc.time.Iso8601;

/**
 * @author gutman
 */
public class CalendarConverterToLocalDateTime implements ConverterToType<LocalDateTime> {

    @Override
    public LocalDateTime convert(@Nullable String s, ActionInvocationContext invocationContext) {
        return s == null ? null : Iso8601.parseLocalDateTime(s);
    }
}
