package ru.yandex.calendar.frontend.a3.converters;

import javax.annotation.Nullable;

import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.convert.ConverterToType;

/**
 * @author dbrylev
 */
public class ConverterToInstantIsoDateTime implements ConverterToType<Instant> {
    private static final DateTimeFormatter formatter = ISODateTimeFormat.dateTimeNoMillis().withOffsetParsed();

    @Override
    public Instant convert(@Nullable String s, ActionInvocationContext invocationContext) {
        return s == null ? null : formatter.parseDateTime(s).toInstant();
    }
}
