package ru.yandex.calendar.frontend.a3.error;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;

public class HttpCodeExceptionHandlers {

    static boolean canHandle(ActionInvocationContext context) {
        return context.getActionDescriptor().exists(d -> d.hasAnnotation(WithHttpErrorCodes.class));
    }

    @Configuration
    public static class ContextConfiguration {

        @Bean
        public OptionalA3ExceptionHandler optionalA3ExceptionHandler() {
            return new OptionalA3ExceptionHandler();
        }

        @Bean
        public OptionalAnyExceptionHandler optionalAnyExceptionHandler() {
            return new OptionalAnyExceptionHandler();
        }

        @Bean
        public OptionalHttpStatusCodeSourceExceptionHandler optionalHttpStatusCodeSourceExceptionHandler() {
            return new OptionalHttpStatusCodeSourceExceptionHandler();
        }
    }
}
