package ru.yandex.calendar.frontend.a3.error;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.user.NameI18n;
import ru.yandex.commune.a3.action.result.error.ErrorCollection;
import ru.yandex.commune.a3.action.result.error.ErrorResult;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author dbrylev
 */
@XmlRootElement(name = "error")
@ActionResultPojo
@BenderBindAllFields
public class ReadableMessageErrorResult extends ErrorResult {

    private final NameI18n readable;

    public ReadableMessageErrorResult(String name, String message, NameI18n readable) {
        super(name, message);
        this.readable = readable;
    }

    public ReadableMessageErrorResult(
            String name, String message, NameI18n readable, ErrorCollection errorCollection)
    {
        super(name, message, errorCollection);
        this.readable = readable;
    }

    public ReadableMessageErrorResult(
            String name, String message, NameI18n readable,
            Option<String> stackTrace, Option<ErrorCollection> errorCollection)
    {
        super(name, message, stackTrace, errorCollection);
        this.readable = readable;
    }
}
