package ru.yandex.calendar.frontend.a3.error;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.error.CommonErrorNames;
import ru.yandex.commune.a3.action.result.error.ErrorNameSource;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionHandlerOrders;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;
import ru.yandex.misc.ExceptionUtils;

/**
 * @author dbrylev
 */
public class ReadableMessageExceptionHandler implements ExceptionHandler {

    @Override
    public Option<?> handleException(
            WebRequest webRequest, ActionInvocationContext invocationContext,
            ExceptionResolver exceptionResolver, Exception exception)
    {
        if (exception instanceof ReadableErrorMessageSource) {
            String errorName = exception instanceof ErrorNameSource
                    ? ((ErrorNameSource) exception).getErrorName()
                    : CommonErrorNames.UNKNOWN;

            return Option.of(new ReadableMessageErrorResult(
                    errorName, exception.getLocalizedMessage(),
                    ((ReadableErrorMessageSource) exception).getReadableMessage(),
                    Option.of(ExceptionUtils.getStackTrace(exception)), Option.empty()));
        }
        return Option.empty();
    }

    @Override
    public int getOrder() {
        return ExceptionHandlerOrders.CUSTOM_EXCEPTION_HANDLER_ORDER;
    }
}
