package ru.yandex.calendar.frontend.a3.interceptors;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.intercept.ActionDispatcherInterceptor;
import ru.yandex.commune.a3.action.intercept.DispatcherInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.ResultType;
import ru.yandex.misc.lang.Validate;

/**
 * @see ru.yandex.commune.a3.action.result.SetResultTypeInterceptor
 */
public class CalendarSetResultTypeInterceptor implements ActionDispatcherInterceptor {
    @Override
    public void beforeDispatch(WebRequest webRequest, ActionInvocationContext invocationContext) throws Exception {
        Option<String> output = webRequest.getParameter("output").firstO();

        if (output.isPresent()) {
            Validate.in(output.get(), Cf.list("xml", "json"));
            invocationContext.setResultTypes(Cf.list(ResultType.R.valueOf(output.get()).getMediaType()));
        }
    }

    @Override
    public int getOrder() {
        return DispatcherInterceptorOrders.SET_RESULT_TYPE_INTERCEPTOR_ORDER + 1;
    }
}
