package ru.yandex.calendar.frontend.a3.interceptors;

import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.calendar.frontend.web.cmd.run.PermissionDeniedUserException;
import ru.yandex.calendar.monitoring.WebApiMonitoring;
import ru.yandex.calendar.tvm.exceptions.TvmUnauthenticatedException;
import ru.yandex.calendar.tvm.exceptions.TvmUnauthorizedException;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.action.parameter.IllegalParameterException;
import ru.yandex.commune.a3.utils.Ordered;

public class CommandExecutionMonitoringInterceptor implements ActionInvocationInterceptor {
    @Autowired
    private WebApiMonitoring webApiMonitoring;

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        val req = invocation.getWebRequest().getHttpServletRequest();
        val uri = req.getRequestURI();
        try {
            val result = invocation.invoke();
            webApiMonitoring.reportSuccessExecution(uri);
            return result;
        } catch (CommandRunException e) {
            if (e.isAdmissibleError() || e.getSituation().isPresent()) {
                webApiMonitoring.reportSuccessExecution(uri);
            } else {
                webApiMonitoring.reportErrorExecution(uri, e);
            }
            throw e;
        } catch (PermissionDeniedUserException | IllegalParameterException | TvmUnauthenticatedException | TvmUnauthorizedException e) {
            webApiMonitoring.reportSuccessExecution(uri);
            throw e;
        } catch (Throwable t) {
            webApiMonitoring.reportErrorExecution(uri, t);
            throw t;
        }
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}
