package ru.yandex.calendar.frontend.a3.interceptors;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.update.LockResource;
import ru.yandex.calendar.logic.update.LockTransactionManager;
import ru.yandex.commune.a3.action.CloneableAction;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.action.invoke.CloneableActionInvocation;
import ru.yandex.misc.ExceptionUtils;

/**
 * @author dbrylev
 */
public class LockAndTransactionInterceptor implements ActionInvocationInterceptor {

    @Autowired
    private LockTransactionManager lockTransactionManager;

    @Override
    public Object intercept(ActionInvocation invocation) {
        if (invocation instanceof CloneableActionInvocation) {
            CloneableAction action = ((CloneableActionInvocation) invocation).getAction();

            if (action instanceof ActionWithLockAndTransaction) {
                return invokeWithLockAndTransaction(((ActionWithLockAndTransaction) action).getResourcesToLock(), invocation);
            }
        }
        return invoke(invocation);
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.MASTER_SLAVE_INTERCEPTOR_ORDER;
    }

    private Object invoke(ActionInvocation invocation) {
        try {
            return invocation.invoke();
        } catch (Exception e) {
            throw ExceptionUtils.throwException(e);
        }
    }

    private Object invokeWithLockAndTransaction(ListF<LockResource> subjectsToLock, final ActionInvocation invocation) {
        return lockTransactionManager.lockAndDoInTransaction(subjectsToLock, () -> invoke(invocation));
    }
}
