package ru.yandex.calendar.frontend.a3.interceptors;

import lombok.extern.slf4j.Slf4j;
import lombok.val;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.action.parameter.Parameter;
import ru.yandex.commune.a3.action.parameter.SimpleBindingParameters;

@Slf4j
public class LogActionParametersInterceptor implements ActionInvocationInterceptor {
    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        ListF<String> pairs = Cf.arrayList();
        for (val param : invocation.getParameters()
                .sortedByDesc(p -> getName(p).isPresent())
                .sortedByDesc(p -> p.getDescriptor().isSimpleBinding()))
        {
            pairs.add(getName(param).plus(getValue(param)).mkString("="));
        }

        log.debug("Invoking action {} with parameters: {}",
                invocation.getActionDescriptor().getName(), pairs.mkString("[", ", ", "]"));
        return invocation.invoke();
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.COMMON_ATTRIBUTES_INTERCEPTOR_ORDER - 2;
    }

    private static Option<String> getName(Parameter param) {
        val binder = param.getDescriptor().getParameterBinder();

        if (binder instanceof LoggingParameterBinder) {
            return ((LoggingParameterBinder) binder).getNameForLogging(param);
        }
        val binding = param.getDescriptor().getSimpleBindingParameters();

        return binding.map(SimpleBindingParameters::getName);
    }

    private static Option<String> getValue(Parameter param) {
        val binder = param.getDescriptor().getParameterBinder();

        if (binder instanceof LoggingParameterBinder) {
            return ((LoggingParameterBinder) binder).getValueForLogging(param);
        }

        return param.getValue().map(Object::toString);
    }
}
