package ru.yandex.calendar.frontend.a3.interceptors;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.CalendarDataSourceStatus;
import ru.yandex.calendar.util.net.CalendarHostnameUtils;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;

/**
 * @author dbrylev
 */
public class SetAdditionalAttrsInterceptor implements ActionInvocationInterceptor {
    @Autowired
    private CalendarDataSourceStatus dataSourceStatus;

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        if (dataSourceStatus.isMasterUnavailable()) {
            invocation.getContext().addAdditionalAttr("master-db-unavailable", "true");
        }
        invocation.getContext().addAdditionalAttr("host-id", CalendarHostnameUtils.getLocalhostId().getOrElse(""));
        return invocation.invoke();
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.COMMON_ATTRIBUTES_INTERCEPTOR_ORDER - 1;
    }
}
