package ru.yandex.calendar.frontend.a3.redirect;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.sharding.ShardingLocator;
import ru.yandex.commune.a3.action.intercept.ActionDispatcherInterceptor;
import ru.yandex.commune.a3.action.intercept.DispatcherInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.utils.ParameterRef;
import ru.yandex.commune.a3.utils.ParameterRetriever;
import ru.yandex.commune.a3.utils.ParameterRetrieverFactory;
import ru.yandex.inside.passport.PassportUid;

public class RedirectActionDispatcherInterceptor implements ActionDispatcherInterceptor {

    private final ParameterRetriever<PassportUid> uidRetriever =
            ParameterRetrieverFactory.cons(PassportUid.class, ParameterRef.request("uid"));

    @Autowired
    private ShardingLocator shardingLocator;

    @Override
    public void beforeDispatch(WebRequest webRequest, ActionInvocationContext invocationContext) {
        Option<PassportUid> uid = uidRetriever.retrieve(webRequest, invocationContext);
        Option<String> host = uid.flatMapO(shardingLocator::getHostToRedirect);

        if (host.isPresent()) {
            throw new RedirectToHostException(host.get());
        }
    }

    @Override
    public int getOrder() {
        return DispatcherInterceptorOrders.SET_RESULT_TYPE_INTERCEPTOR_ORDER + 33;
    }
}
