package ru.yandex.calendar.frontend.a3.redirect;

import ru.yandex.commune.a3.action.result.error.ErrorLogLevelSource;
import ru.yandex.misc.log.mlf.Level;

public class RedirectToHostException extends RuntimeException implements ErrorLogLevelSource {

    private final String host;

    public RedirectToHostException(String host) {
        super(host);
        this.host = host;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public Level getErrorLogLevel() {
        return Level.INFO;
    }

    public String getHost() {
        return host;
    }
}
