package ru.yandex.calendar.frontend.a3.redirect;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.NoContent;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;
import ru.yandex.commune.a3.utils.Ordered;

public class RedirectToHostExceptionHandler implements ExceptionHandler {

    private static final String ACCEL_REDIRECT = "X-Accel-Redirect";

    @Override
    public Option<?> handleException(
            WebRequest webRequest,
            ActionInvocationContext invocationContext,
            ExceptionResolver exceptionResolver,
            Exception exception
    ) {
        if (exception instanceof RedirectToHostException) {
            String method = webRequest.getHttpServletRequest().getMethod();
            String host = ((RedirectToHostException) exception).getHost();

            String redirect = "/proxy/" + method + "/" + host;
            webRequest.getHttpServletResponse().addHeader(ACCEL_REDIRECT, redirect);

            return Option.of(NoContent.cons());
        }
        return Option.empty();
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}
