package ru.yandex.calendar.frontend.api;

import org.joda.time.Instant;

import ru.yandex.calendar.frontend.bender.UnicodeEmailMarshaller;
import ru.yandex.calendar.frontend.bender.UnicodeEmailUnmarshaller;
import ru.yandex.calendar.frontend.bender.WebDateTime;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.InstantAsMillisMarshaller;
import ru.yandex.misc.bender.custom.InstantAsMillisUnmarshaller;
import ru.yandex.misc.bender.serialize.simpleType.StringValueMarshaller;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class ApiBender {

    public static BenderConfiguration getConfiguration() {
        return BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryBuilder.cons()
                        .add(Instant.class, new InstantAsMillisMarshaller(), new InstantAsMillisUnmarshaller())
                        .add(Email.class, new UnicodeEmailMarshaller(), new UnicodeEmailUnmarshaller())
                        .build());
    }

    public static BenderConfiguration getConfigurationForLogging() {
        return BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryBuilder.cons()
                        .add(Instant.class, new ToStringMarshaller())
                        .add(Email.class, new ToStringMarshaller())
                        .add(WebDateTime.class, new ToStringMarshaller())
                        .build());
    }

    private static class ToStringMarshaller extends StringValueMarshaller {
        protected String toStringValue(Object o) {
            return o.toString();
        }
    }
}
