package ru.yandex.calendar.frontend.api;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.boot.CalendarAppName;
import ru.yandex.calendar.frontend.a3.bind.JsonBinder;
import ru.yandex.calendar.frontend.a3.converters.CalendarConverterToLocalDateTime;
import ru.yandex.calendar.frontend.a3.converters.ConverterToDateTimeZone;
import ru.yandex.calendar.frontend.a3.converters.ConverterToEmail;
import ru.yandex.calendar.frontend.a3.error.HttpCodeExceptionHandlers;
import ru.yandex.calendar.frontend.a3.interceptors.CalendarRequestInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.CalendarSetResultTypeInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.CommandExecutionMonitoringInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.LockAndTransactionInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.LogActionParametersInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.SetAdditionalAttrsInterceptor;
import ru.yandex.calendar.frontend.a3.redirect.RedirectContextA3Configuration;
import ru.yandex.calendar.frontend.api.event.ApiEventContextConfiguration;
import ru.yandex.calendar.frontend.api.ics.ApiIcsContextConfiguration;
import ru.yandex.calendar.frontend.api.inviter.ApiInviterContextConfiguration;
import ru.yandex.calendar.frontend.api.staff.ApiStaffContextConfiguration;
import ru.yandex.calendar.frontend.api.todo.ApiTodoContextConfiguration;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.log.requests.RequestLoggingContextA3Configuration;
import ru.yandex.calendar.monitoring.WebApiMonitoringConfiguration;
import ru.yandex.calendar.tvm.TvmManager;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.A3DefaultContextConfiguration;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ApplicationResultType;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.commune.dynproperties.DynamicPropertyRegistry;
import ru.yandex.misc.version.Version;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
@Import({
        A3DefaultContextConfiguration.class,
        ApiEventContextConfiguration.class,
        ApiInviterContextConfiguration.class,
        ApiTodoContextConfiguration.class,
        ApiIcsContextConfiguration.class,
        ApiStaffContextConfiguration.class,
        WebApiMonitoringConfiguration.class,
        HttpCodeExceptionHandlers.ContextConfiguration.class,
        RequestLoggingContextA3Configuration.class,
        RedirectContextA3Configuration.class,
})
public class ApiContextA3Configuration {

    @Autowired
    @Qualifier("apiJetty")
    private SingleWarJetty jetty;
    @Autowired
    private ActionApp actionApp;

    @PostConstruct
    public void configure() {
        jetty.addServletMapping("/api/*", actionApp.createServlet());
    }

    @Bean
    public ApplicationInfo applicationInfo(CalendarAppName calendarAppName, Version version) {
        return new ApplicationInfo(calendarAppName.appName(), version.getProjectVersion());
    }

    @Bean
    public ApplicationResultType applicationResultType() {
        return new ApplicationResultType(MediaType.APPLICATION_XML);
    }

    @Bean
    public CalendarRequestInterceptor calendarRequestInterceptor(
            PassportAuthDomainsHolder domains, TvmManager tvmManager) {
        return new CalendarRequestInterceptor(ActionSource.INTERNAL_API, domains, tvmManager);
    }

    @Bean
    public SetAdditionalAttrsInterceptor setAdditionalAttrsInterceptor() {
        return new SetAdditionalAttrsInterceptor();
    }

    @Bean
    public LockAndTransactionInterceptor lockAndTransactionInterceptor() {
        return new LockAndTransactionInterceptor();
    }

    @Bean
    public LogActionParametersInterceptor logActionParametersInterceptor() {
        return new LogActionParametersInterceptor();
    }

    @Bean
    public JsonBinder jsonBinder() {
        return new JsonBinder(ApiBender.getConfiguration(), ApiBender.getConfigurationForLogging());
    }

    @Bean
    public CalendarSetResultTypeInterceptor calendarSetResultTypeInterceptor() {
        return new CalendarSetResultTypeInterceptor();
    }

    @Bean
    public ConverterToEmail converterToEmail() {
        return new ConverterToEmail();
    }

    @Bean
    public CalendarConverterToLocalDateTime converterToLocalDateTime() {
        return new CalendarConverterToLocalDateTime();
    }

    @Bean
    public ConverterToDateTimeZone converterToDateTimeZone() {
        return new ConverterToDateTimeZone();
    }

    @Bean
    public GetHolidaysAction getHolidaysAction() {
        return new GetHolidaysAction();
    }

    @Bean
    public DeleteSpamEventAction deleteSpamEventAction(DynamicPropertyRegistry registry) {
        registry.addStaticFields(DeleteSpamEventAction.class);
        return new DeleteSpamEventAction();
    }

    @Bean
    public CommandExecutionMonitoringInterceptor commandExecutionMonitoringInterceptor() {
        return new CommandExecutionMonitoringInterceptor();
    }
}
