package ru.yandex.calendar.frontend.api;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.admin.CalendarPingServlet;
import ru.yandex.calendar.frontend.api.mail.ApiMailContextConfiguration;
import ru.yandex.calendar.frontend.api.webNew.ApiWebNewContextConfiguration;
import ru.yandex.calendar.logic.log.requests.RequestContentCachingFilter;
import ru.yandex.calendar.logic.log.requests.RequestLoggingContextConfiguration;
import ru.yandex.calendar.unistat.ApiUnistatContextConfiguration;
import ru.yandex.calendar.util.JettyConfiguration;
import ru.yandex.calendar.util.spring.ChildApplicationContextLoader;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
@Import({
        ApiMailContextConfiguration.class,
        ApiWebNewContextConfiguration.class,
        ApiUnistatContextConfiguration.class,
        RequestLoggingContextConfiguration.class,
})
public class ApiContextConfiguration {

    @Bean
    public ApiManager apiManager() {
        return new ApiManager();
    }

    @Bean
    @Qualifier("apiJetty")
    public SingleWarJetty apiJetty(RequestContentCachingFilter cachingFilter) {
        SingleWarJetty jetty = JettyConfiguration.fromProperties("api").consJetty();

        jetty.addServletMapping("/ping/*", apiPingConfigurableServlet());
        jetty.addFilterMapping("/*", cachingFilter);

        return jetty;
    }

    @Bean
    public CalendarPingServlet apiPingConfigurableServlet() {
        return new CalendarPingServlet();
    }

    @Bean
    public ChildApplicationContextLoader apiA3ContextLoader() {
        return new ChildApplicationContextLoader(ApiContextA3Configuration.class);
    }
}
