package ru.yandex.calendar.frontend.api;

import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.holidays.DayInfo;
import ru.yandex.commune.holidays.DayInfoHandler;
import ru.yandex.commune.holidays.HolidayRoutines;
import ru.yandex.commune.holidays.OutputMode;
import ru.yandex.misc.time.TimeFormats;

/**
 * @see ru.yandex.calendar.frontend.web.cmd.run.api.CmdGetHolidays
 *
 * @author dbrylev
 */
public class GetHolidaysAction extends XmlOrJsonApiActionSupport {

    @RequestParam(required = false)
    private OutputMode outMode = OutputMode.HOLIDAYS;

    @RequestParam
    private LocalDate startDate;
    @RequestParam
    private Option<LocalDate> endDate;

    @RequestParam
    private int countryId;
    @RequestParam(required = false)
    private boolean forYandex = false;

    @Override
    protected XmlOrJsonWritable doExecute() {
        return new XmlOrJsonWritable() {
            public void write(final XmlOrJsonWriter w) {
                w.startArray("days");

                LocalDate end = endDate.getOrElse(startDate);

                HolidayRoutines.processDates(startDate, end, countryId, outMode, forYandex, new DayInfoHandler() {
                    public void handle(LocalDate date, DayInfo info) {
                        w.startObject("day");

                        w.addTextField("date", date.toString(TimeFormats.ISO_DATE_FORMATTER));
                        w.addTextField("type", info.getDayType().value());

                        w.addBooleanField("is-day-off", info.isDayOff());
                        w.addBooleanField("is-transfer", info.isTransfer());

                        if (info.getNameO().isPresent()) {
                            w.addTextField("name", info.getNameO().get());
                        }
                        w.endObject();
                    }
                });
                w.endArray();
            }
        };
    }

}
