package ru.yandex.calendar.frontend.api;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.a3.action.result.xml.XmlWriterActionResult;
import ru.yandex.commune.a3.action.result.xml.XmlWriterUtils;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author dbrylev
 */
public class XmlApiActionResult implements XmlWriterActionResult {

    private final XmlWritable writable;

    public XmlApiActionResult(XmlWritable writable) {
        this.writable = writable;
    }

    @Override
    public void write(XmlWriter xw, Tuple2List<String, Object> additionalAttributes) {
        xw.startElement("result");
        XmlWriterUtils.writeAdditionalAttrs(xw, additionalAttributes);

        writable.write(xw);
        xw.endElement();
    }
}
