package ru.yandex.calendar.frontend.api;

import ru.yandex.calendar.CalendarRequest;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.commune.a3.action.CloneableAction;
import ru.yandex.commune.a3.action.result.xml.XmlActionResult;

/**
 * @author gutman
 */
public abstract class XmlApiActionSupport implements CloneableAction {

    private ActionInfo actionInfo;

    protected abstract XmlWritable doExecute();

    @Override
    public XmlActionResult execute() throws Exception {
        actionInfo = CalendarRequest.getCurrent().getActionInfo();

        return new XmlApiActionResult(doExecute());
    }

    public ActionInfo getActionInfo() {
        return actionInfo;
    }
}
