package ru.yandex.calendar.frontend.api;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.calendar.util.xmlorjson.JsonBuilder;
import ru.yandex.calendar.util.xmlorjson.XmlWriter;
import ru.yandex.commune.a3.action.result.json.JsonWriterUtils;
import ru.yandex.commune.a3.action.result.xml.XmlWriterUtils;
import ru.yandex.commune.a3.action.result.xmlOrJson.XmlOrJsonActionResult;
import ru.yandex.commune.xmlOrJson.XmlOrJsonWriter;

/**
 * @author dbrylev
 */
public class XmlOrJsonApiActionResult extends XmlOrJsonActionResult {

    private final XmlOrJsonWritable writable;

    public XmlOrJsonApiActionResult(XmlOrJsonWritable writable) {
        this.writable = writable;
    }

    @Override
    public void write(XmlOrJsonWriter w, Tuple2List<String, Object> additionalAttributes) {
        if (w.actualType() == XmlOrJsonWriter.Type.JSON) {
            JsonBuilder jb = new JsonBuilder(w.getJsonWriter());

            jb.startObject("");
            jb.startObject("invocation-info");

            JsonWriterUtils.writeAdditionalAttrs(jb.getJsonWriter(), additionalAttributes);
            jb.endObject();

            writable.write(jb);
            jb.endObject();

        } else {
            XmlWriter xw = new XmlWriter(w.getXmlWriter());

            xw.startObject("result");
            XmlWriterUtils.writeAdditionalAttrs(w.getXmlWriter(), additionalAttributes);

            writable.write(xw);
            xw.endObject();
        }
    }
}
