package ru.yandex.calendar.frontend.api;

import ru.yandex.calendar.CalendarRequest;
import ru.yandex.calendar.frontend.a3.interceptors.ActionSourceAwareAction;
import ru.yandex.calendar.frontend.api.todo.OutputMode;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.commune.a3.action.CloneableAction;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.commune.a3.action.result.xmlOrJson.XmlOrJsonActionResult;

/**
 * @author gutman
 * @author Sergey Shinderuk
 */
public abstract class XmlOrJsonApiActionSupport implements CloneableAction, ActionSourceAwareAction {

    @RequestParam(required = false)
    private OutputMode outputMode = OutputMode.FULL;
    @SpecialParam
    private WebRequest webRequest;

    private ActionInfo actionInfo;

    protected abstract XmlOrJsonWritable doExecute();

    @Override
    public final XmlOrJsonActionResult execute() throws Exception {
        actionInfo = CalendarRequest.getCurrent().getActionInfo();

        return new XmlOrJsonApiActionResult(doExecute());
    }

    protected ActionInfo getActionInfo() {
        return actionInfo;
    }

    public ActionSource getActionSource() {
        if (webRequest.getHeader("x-yandex-clienttype").isSome("MAYA")) {
            return ActionSource.WEB_MAYA;
        }
        return outputMode == OutputMode.MOBILE ? ActionSource.MOBILE : ActionSource.INTERNAL_API;
    }

    protected OutputMode getOutputMode() {
        return outputMode;
    }
}
