package ru.yandex.calendar.frontend.api;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;

/**
 * @author dbrylev
 */
public interface XmlOrJsonWritable {
    void write(XmlOrJsonWriter writer);

    default XmlOrJsonWritable chainTo(final XmlOrJsonWritable next) {
        return w -> {
            XmlOrJsonWritable.this.write(w);
            next.write(w);
        };
    }

    static XmlOrJsonWritable textFields(final Tuple2List<String, String> fields) {
        return w -> {
            for (Tuple2<String, String> field : fields) {
                w.addTextField(field._1, field._2);
            }
        };
    }

    static XmlOrJsonWritable empty() {
        return textFields(Tuple2List.<String, String>tuple2List());
    }

    static XmlOrJsonWritable textField(final String name, final String value) {
        return textFields(Tuple2List.fromPairs(name, value));
    }

    static XmlOrJsonWritable textField(String name, long value) {
        return textFields(Tuple2List.fromPairs(name, Long.toString(value)));
    }

    static XmlOrJsonWritable textFields(String name1, String value1, String name2, String value2) {
        return textFields(Tuple2List.fromPairs(name1, value1, name2, value2));
    }
}
