package ru.yandex.calendar.frontend.api;

import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author dbrylev
 */
public abstract class XmlWritable {

    public abstract void write(XmlWriter writer);

    public static XmlWritable empty() {
        return new XmlWritable() {
            public void write(XmlWriter w) {}
        };
    }

    public static XmlWritable textElement(final String name, final String value) {
        return new XmlWritable() {
            public void write(XmlWriter w) {
                w.textElement(name, value);
            }
        };
    }

    public static XmlWritable textElement(String name, long value) {
        return textElement(name, Long.toString(value));
    }
}
