package ru.yandex.calendar.frontend.api.event;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantIsoDateTime;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantMillis;
import ru.yandex.calendar.frontend.api.XmlOrJsonApiActionSupport;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author dbrylev
 */
public abstract class ActionWithIntervalParams extends XmlOrJsonApiActionSupport {
    @RequestParam(customConverter = ConverterToInstantIsoDateTime.class)
    private Option<Instant> from = Option.empty();
    @RequestParam(customConverter = ConverterToInstantIsoDateTime.class)
    private Option<Instant> to = Option.empty();
    @RequestParam(customConverter = ConverterToInstantMillis.class)
    private Option<Instant> fromTs = Option.empty();
    @RequestParam(customConverter = ConverterToInstantMillis.class)
    private Option<Instant> toTs = Option.empty();

    protected Instant getFrom() {
        return from.orElse(fromTs).getOrElse(Instant.now());
    }

    protected Instant getTo() {
        return to.orElse(toTs).getOrElse(getFrom());
    }
}
