package ru.yandex.calendar.frontend.api.event;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantIsoDateTime;
import ru.yandex.calendar.frontend.api.XmlOrJsonApiActionSupport;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.event.CreateInfo;
import ru.yandex.calendar.logic.event.model.EventData;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.logic.sharing.InvitationProcessingMode;
import ru.yandex.calendar.util.dates.DateTimeManager;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.Validate;

/**
 * @author dbrylev
 */
public class CreateEventOnLayer extends XmlOrJsonApiActionSupport {

    @Autowired
    private LayerRoutines layerRoutines;
    @Autowired
    private EventWebManager eventWebManager;
    @Autowired
    private DateTimeManager dateTimeManager;

    @RequestParam
    private String layerPrivateToken;
    @RequestParam
    private String name;
    @RequestParam
    private Option<String> description;
    @RequestParam(customConverter = ConverterToInstantIsoDateTime.class)
    private Instant start;
    @RequestParam(customConverter = ConverterToInstantIsoDateTime.class)
    private Instant end;

    @Override
    protected XmlOrJsonWritable doExecute() {
        Layer layer = layerRoutines.getByPrivateToken(layerPrivateToken);

        PassportUid uid = layer.getCreatorUid();
        CreateInfo created = eventWebManager.createUserEvent(
                uid, eventData(uid, layer.getId()), InvitationProcessingMode.SAVE_ONLY, getActionInfo());

        return XmlOrJsonWritable.textField("event-id", created.getEventId());
    }

    private EventData eventData(PassportUid uid, long layerId) {
        EventData data = new EventData();
        Validate.isFalse(end.isBefore(start));

        data.getEvent().setStartTs(start);
        data.getEvent().setEndTs(end);
        data.getEvent().setIsAllDay(false);
        data.setTimeZone(dateTimeManager.getTimeZoneForUid(uid));

        data.setLayerId(layerId);
        data.getEvent().setName(name);
        data.getEvent().setDescription(description.getOrElse(""));

        return data;
    }
}
