package ru.yandex.calendar.frontend.api.event;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.api.XmlApiActionSupport;
import ru.yandex.calendar.frontend.api.XmlWritable;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.sharing.InvitationProcessingMode;
import ru.yandex.calendar.logic.user.UserInfo;
import ru.yandex.calendar.logic.user.UserManager;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author gutman
 */
public class DeleteEventAction extends XmlApiActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(DeleteEventAction.class);

    @Autowired
    private UserManager userManager;
    @Autowired
    protected EventRoutines eventRoutines;

    @RequestParam
    private Email email;
    @RequestParam
    private long id;

    @Override
    protected XmlWritable doExecute() {
        logger.debug("Deleting event: id " + id + " , login " + email);

        PassportUid uid = userManager.getUidByEmail(email).getOrThrow("unknown user " + email);
        UserInfo user = userManager.getUserInfo(uid);

        ActionInfo actionInfo = getActionInfo();

        eventRoutines.deleteEvent(Option.of(user), id, InvitationProcessingMode.SAVE_ATTACH, actionInfo);
        return XmlWritable.empty();
    }

    @Deprecated
    @RequestParam(required = false)
    // for compatibility with moikrug
    public void setLogin(String login) {
        this.email = new Email(login);
    }
}
