package ru.yandex.calendar.frontend.api.event;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.a3.converters.ConverterToInstantMillis;
import ru.yandex.calendar.frontend.api.XmlOrJsonApiActionSupport;
import ru.yandex.calendar.frontend.api.XmlOrJsonWritable;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.event.EventInstanceInfo;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.LayerIdPredicate;
import ru.yandex.calendar.logic.sharing.participant.Participants;
import ru.yandex.calendar.util.xmlorjson.XmlOrJsonWriter;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author dbrylev
 */
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetUserEvents extends XmlOrJsonApiActionSupport {

    @Autowired
    private EventRoutines eventRoutines;

    @RequestParam
    private PassportUid uid;
    @RequestParam(customConverter = ConverterToInstantMillis.class)
    private Instant from;
    @RequestParam(customConverter = ConverterToInstantMillis.class)
    private Instant to;

    @Override
    protected XmlOrJsonWritable doExecute() {
        final ListF<EventInstanceInfo> events = eventRoutines.getSortedInstancesIMayView(
                Option.of(uid), from, Option.of(to),
                LayerIdPredicate.allForUser(uid, true), ActionSource.INTERNAL_API);

        return new XmlOrJsonWritable() {
            public void write(XmlOrJsonWriter w) {
                w.startArray("events");
                for (EventInstanceInfo event : events) {
                    w.startObject("event");
                    EventSerializer.serializeEventFields(w, event.getEvent(), event.getInterval(), Option.empty());

                    w.addBooleanField("viewable-to-anyone", !event.getInfoForPermsCheck().isPrivate());
                    event.getLayerId().forEach(id -> w.addTextField("layer-id", id));

                    Participants participants = event.getEventWithRelations().getParticipants();

                    if (participants.isMeetingOrInconsistent()) {
                        EventSerializer.serializeParticipants(w, participants.getParticipantsSafeWithInconsistent());
                    }
                    w.endObject();
                }
                w.endArray();
            }
        };
    }
}
